DROP VIEW IF EXISTS softsat_locacao_contrato_relatorio;

CREATE VIEW softsat_locacao_contrato_relatorio AS
SELECT 
    con.*,
    cli.nome AS cliente,
    cli.cnpj_cpf AS cliente_cnpj_cpf,
    cli.email AS cliente_email,
    cli.endereco AS cliente_endereco,
    cli.numero AS cliente_numero,
    cli.bairro AS cliente_bairro,
    cli.cidade AS cliente_cidade,
    cli.estado AS cliente_estado,
    cli.cep AS cliente_cep,
    tar.nome AS tarifa,
    IF(con.km_entrada - con.km_saida < 0, NULL, con.km_entrada - con.km_saida) AS km_utilizado,
    vei.placa AS veiculo_placa,
    vei.nome AS veiculo_nome,
    vei.modelo AS veiculo_modelo,
    vei.grupo AS veiculo_grupo,
    vei.marca AS veiculo_marca,
    vei.grupo_id AS veiculo_grupo_id,
    vei.marca_id AS veiculo_marca_id,
    vei.combustivel_id AS veiculo_combustivel_id,
    fpag.nome AS forma_pagamento,
    lsai.nome AS local_saida,
    lsai.razao AS local_saida_razao,
    lsai.cnpj AS local_saida_cnpj,
    lsai.endereco AS local_saida_endereco,
    lsai.numero AS local_saida_numero,
    lsai.bairro AS local_saida_bairro,
    lsai.cidade AS local_saida_cidade,
    lsai.estado AS local_saida_estado,
    lsai.cep AS local_saida_cep,
    lsai.telefone AS local_saida_telefone,
    lsai.email AS local_saida_email,
    lent.nome AS local_entrada,
    lent.razao AS local_entrada_razao,
    lent.cnpj AS local_entrada_cnpj,
    lent.endereco AS local_entrada_endereco,
    lent.numero AS local_entrada_numero,
    lent.bairro AS local_entrada_bairro,
    lent.cidade AS local_entrada_cidade,
    lent.estado AS local_entrada_estado,
    lent.cep AS local_entrada_cep,
    lent.telefone AS local_entrada_telefone,
    lent.email AS local_entrada_email
FROM softsat_locacao_contrato AS con
LEFT JOIN softsat_locacao_cliente AS cli ON cli.id = con.cliente_id
LEFT JOIN softsat_locacao_veiculo_detalhe AS vei ON vei.id = con.veiculo_id
LEFT JOIN softsat_locacao_tarifa AS tar ON tar.id = con.tarifa_id
LEFT JOIN softsat_locacao_forma_pagamento AS fpag ON fpag.id = con.forma_pagamento_id
LEFT JOIN softsat_locacao_local AS lsai ON lsai.id = con.local_saida_id
LEFT JOIN softsat_locacao_local AS lent ON lent.id = con.local_entrada_id;
/*
DROP VIEW IF EXISTS softsat_locacao_contrato_relatorio;

CREATE VIEW softsat_locacao_contrato_relatorio AS
    SELECT
        con.*,
        con.diaria_excedido * con.dias_excedidos AS valor_excedido,
        GREATEST(IF(MOD(con.dias_previsto, 1.0) >= 0.5, CEIL(con.dias_previsto), con.dias_previsto), 1) * con.diaria AS valor_previsto,
        con.dias_normais * con.diaria AS valor_normal,
        COALESCE(con.diaria_excedido * con.dias_excedidos, 0) + 
            ((con.dias_utilizado - COALESCE(con.dias_excedidos, 0)) * con.diaria) AS valor_utilizado,
        GREATEST(IF(MOD(con.dias_normal, 1.0) >= 0.5, CEIL(con.dias_normal), con.dias_normal), 1) * con.diaria AS valor_cobrado,
        GREATEST(IF(MOD(con.dias_normal, 1.0) >= 0.5, CEIL(con.dias_normal), con.dias_normal), 1) AS dias_cobrado,

    FROM softsat_locacao_contrato_detalhe AS con
    
CREATE FUNCTION TO_DAYS_F(d DATETIME) RETURNS DOUBLE DETERMINISTIC
    RETURN TO_SECONDS(d) / 60 / 60 / 24;
    
CREATE FUNCTION DATE_DIFF_F(a DATETIME, b DATETIME) RETURNS DOUBLE DETERMINISTIC
    RETURN TO_DAYS_F(a) - TO_DAYS_F(b);

CREATE FUNCTION x(saida DATETIME, previsto DATETIME, entrada DATETIME, diaria DECIMAL(10, 2), multa DECIMAL(10, 2)) AS
*/